#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12379);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0085","CAN-2003-0086");
			
 name["english"] = "RHSA-2003-096: Samba";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of SAMBA prior to 2.2.8.

Samba is a suite of utilities for allowing Linux systems to
interact with SMB/CIFS clients and servers.  This version of
SAMBA is vulnerable to two (2) unique exploits. 

First, SAMBA is vulnerable to a remote overflow which would give
a remote attacker root access.  An attacker, exploiting this flaw,
would need to be able to send fragmented SMB/CIFS packets to the 
SAMBA server.  The server, upon reassembling the packets, be exploited
and the attacker would be able to execute arbitrary code.

Second,  There is a local race condition which occurs when the SAMBA
server calls chown() to set rights on a created file.  An attacker,
exploiting this flaw, would need local access and the ability to know
when the SAMBA server is running and performing a certain registry
function.  Upon successful attack, the local attacker has the ability
to overwrite critical system files.
 
Solution : http://rhn.redhat.com/errata/RHSA-2003-096.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Samba package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"samba-2.2.7-2.21", prefix:"samba-", release:"RHEL2.1") ) 
	security_hole(0);


