#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12380);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2003-0131","CAN-2003-0147");
			
 name["english"] = "RHSA-2003-102: OpenSSL";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using a version of OpenSSL which is vulnerable to
several bugs.

OpenSSL is an open-source SSL/TLS implementation.  There is a flaw in
this version of OpenSSL which can allow a local or remote user to 
obtain the OpenSSL private key. An attacker, exploiting this flaw, would
need the ability to sniff traffic between the OpenSSL server and it's 
remote clients.  Further, the network must be low-latency.  That is,
the attack is dependent on seeing and timestamping the different SSL
packets in transit.

A second flaw, in this version of OpenSSL, could allow remote attackers
to obtain information (or a mapping) between ciphertext and plaintext.  
An attacker, exploiting this flaw, would need the ability to connect
to the OpenSSL server on the SSL port and send multiple PKCS-1 v1.5
paddings.  

Solution : http://rhn.redhat.com/errata/RHSA-2003-102.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the OpenSSL package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"openssl-0.9.6b-32.7", yank:"b", prefix:"openssl-", release:"RHEL2.1") ) 
	security_hole(0);


