#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12381);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2003-0127");
			
 name["english"] = "RHSA-2003-103: kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of the kernel which 
allows local users to elevate privileges to 'root' level.

The Linux kernel is the core of the Linux OS.  The kernel 
handles all the low-level functionality.  This version of
the Linux kernel is vulnerable to a bug wherein a local
attacker can use ptrace to gain root access.  An attacker,
exploiting this flaw, would need to have local access and
the ability to use ptrace to attach to a known vulnerable
process.

Solution : http://rhn.redhat.com/errata/RHSA-2003-103.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"kernel-2.4.9-e.16", yank:"e", prefix:"kernel-", release:"RHEL2.1") ) 
	security_hole(0);


