#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12382);
 script_bugtraq_id(7120, 7269);
 script_version ("$Revision: 1.5 $");
script_cve_id("CAN-2002-1090","CAN-2003-0140");
			
 name["english"] = "RHSA-2003-111: Balsa";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Balsa prior to 1.3.

Balsa is a GNOME email client.  This version of Balsa is 
vulnerable to two (2) remote overflows.  

First, an overflow exists when Balsa parses a mailbox name
which is malformed.  An attacker, exploiting this flaw, would
need to be able to coerce a local user to connect to a malicious
IMAP server.  The IMAP server would then send back a malicious
mailbox name which would generate an overflow within the Balsa
client.

Second, a specially crafted SMTP-server response can cause the
Balsa client to either overflow (potentially executing code) or
fail (Denial of Service).  An attacker, exploiting this flaw,
would need to be able to coerce a Balsa client to connect to a
malicious SMTP server.  The SMTP server would then send back a
malicious reply which would generate an overflow within the 
Balsa client.

Solution : http://rhn.redhat.com/errata/RHSA-2003-111.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Balsa package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"balsa-1.2.4-7.7.2.", prefix:"balsa-", release:"RHEL2.1") ) 
{
	security_hole(0);
	exit(0);
}

if ( rpm_check( reference:"libesmtp-0.8.12-0.7", prefix:"libesmtp-", release:"RHEL2.1") )
        security_hole(0);


