#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12383);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2003-0084");
			
 name["english"] = "RHSA-2003-114: mod_auth_any";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running Apache webserver with mod_auth_any
enabled.  This version of mod_auth_any is vulnerable to a 
remote command-execution flaw.

mod_auth_any is an Apache module which allows the server to call
external programs in order to verify user passwords.  A flaw in 
the way that mod_auth_any parses the incoming data can result in 
a remote attacker passing commandline arguments via the module.
An attacker, exploiting this flaw, would need to be able to connect
to the Apache server and send a malformed UserID/Password which would
then execute code as the UID of the webserver.

Solution : http://rhn.redhat.com/errata/RHSA-2003-114.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mod_auth_any package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"mod_auth_any-1.2.2-2", release:"RHEL2.1") ) 
	security_hole(0);


