#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12384);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2002-1363");
			
 name["english"] = "RHSA-2003-119: mICQ";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of mICQ prior to  0.4.10.

mICQ is an online messaging and conferencing program.  This version
of mICQ is vulnerable to a remote denial of service (DoS) attack
wherein attackers can shut down the ICQ server by sending a 
malformed ICQ message without the typical 0xFE separator.  An attacker,
exploiting this flaw, would need to be able to connect to an ICQ server
and send a malformed message.

Solution : http://rhn.redhat.com/errata/RHSA-2003-119.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the mICQ package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"micq-0.4.10.2-1", release:"RHEL2.1") ) 
	security_hole(0);


