#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12385);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2003-0161");
			
 name["english"] = "RHSA-2003-121: Sendmail";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Sendmail prior to 8.12.9.

Sendmail is a Mail Transport Agent which is used to send and receive
email messages.  This version is flawed in such a way as to allow
a remote attacker to send a malformed packet which crashes or overflows
the Sendmail server.  An attacker, exploiting this flaw, would need to
be able to connect to the Sendmail daemon and send a malformed request.

Solution : http://rhn.redhat.com/errata/RHSA-2003-121.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Sendmail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"sendmail-8.11.6-26.72", prefix:"sendmail-", release:"RHEL2.1") ) 
	security_hole(0);


