#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12386);
 script_bugtraq_id(7066);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2003-0124");
			
 name["english"] = "RHSA-2003-134: man";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of man prior to 1.51.

Man is a tool for displaying documentation about different commands
and configuration files on a system.  This version is vulnerable to 
a flaw wherein specially crafted man files can cause a specific program
to run.  An attacker, exploiting this flaw, would need.
1) local access to the machine

2) the ability to create a malformed man file

3) the ability to create a malicious program named 'unsafe' and placed
in a location where it is in the victim's PATH.

4) the ability to entice a local user to run man on the file created
in two (2) above.

Solution : http://rhn.redhat.com/errata/RHSA-2003-134.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the man package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"man-1.5i2-7.21as.0", yank:"as", release:"RHEL2.1") ) 
	security_hole(0);


