#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12387);
 script_bugtraq_id(7295);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2003-0196","CAN-2003-0201");
			
 name["english"] = "RHSA-2003-138: Samba";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of SAMBA prior to 2.2.9.

Samba is a Linux tool for communicating with SMB/CIFS clients and
servers.  This version of Samba is vulnerable to a flaw wherein a
remote attacker can execute arbitrary code.  An attacker, exploiting
this flaw, would need to be able to connect to the Samba server and
pass a malformed packet.  Upon processing the packet, Samba could be
coerced in executing arbitrary code (overflow) or simply failing (DoS).

Solution : http://rhn.redhat.com/errata/RHSA-2003-138.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Samba package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"samba-2.2.7-3.21as", yank:"as", prefix:"samba-", release:"RHEL2.1") ) 
	security_hole(0);


