#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12389);
 script_bugtraq_id(7318);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2003-0204");
			
 name["english"] = "RHSA-2003-146: KDE";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of KDE prior to 3.1.2.

KDE is a X windows graphical environment.  This version of KDE
is vulnerable to a flaw within the Konqueror web browser.  The
flaw is in the parsing and display of malicious PostScript or
PDF files.  An attacker, exploiting this flaw, would need to
be able to coerce a local user into opening a malicious PDF
or PostScript file with the Konqueror web browser.

Solution : http://rhn.redhat.com/errata/RHSA-2003-146.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the KDE package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"kdebase-2.2.2-9", prefix:"kdebase-", release:"RHEL2.1") ) 
{
	security_hole(0);
	exit(0);
}

if ( rpm_check( reference:"kdegraphics-2.2.2-4", prefix:"kdegraphics-", release:"RHEL2.1") )
{
        security_hole(0);
        exit(0);
}

if ( rpm_check( reference:"kdelibs-2.2.2-7", prefix:"kdelibs-", release:"RHEL2.1") )
{
        security_hole(0);
        exit(0);
}

if ( rpm_check( reference:"arts-2.2.2-7", prefix:"arts-", release:"RHEL2.1") )
        security_hole(0);


