#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12390);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2003-0246");
			
 name["english"] = "RHSA-2003-147: kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a kernel which is vulnerable to
a local escalation-of-privileges attack.

The kernel is the portion of the Linux Operating System which
handles all the low-level functionality.  This version of the 
kernel has a flaw in the ioperm system call which could allow
a local user to gain read or write access to certain I/O ports.
An attacker, exploiting this flaw, would need local access and 
the ability to craft ioperm system calls.  A successful exploitation
could lead to loss of confidential data or escalation of privileges
due to a leaking of sensitive information.

Solution : http://rhn.redhat.com/errata/RHSA-2003-147.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"kernel-2.4.9-e.24", yank:"e", prefix:"kernel-", release:"RHEL2.1") ) 
	security_hole(0);


