#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12391);
 script_bugtraq_id(7334);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2003-0136");
			
 name["english"] = "RHSA-2003-150: LPRng";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running LPRng which is vulnerable to a local symlink
bug.

LPRng is a print spooler. This version of LPRng is flawed in that it
creates print-job files with known filenames.  An attacker, exploiting
this flaw, would need local access and the ability to create symbolic 
links to the known print-job filename.  A successful attack would allow
the local attacker to print arbitrary or potentially confidential data.

Solution : http://rhn.redhat.com/errata/RHSA-2003-150.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the LPRng package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"LPRng-3.7.4-28.2", release:"RHEL2.1") ) 
	security_hole(0);


