#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12392);
 script_bugtraq_id(7606);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2003-0145","CAN-2003-0194");
			
 name["english"] = "RHSA-2003-151: tcpdump";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of tcpdump prior to 3.7.2.

Tcpdump is a command-line tool for sniffing network traffic.  
This version of tcpdump is vulnerable to a flaw when analyzing
the RADIUS protocol.  Specially formatted RADIUS packets can
cause the tcpdump service to go into an infinite loop.  An 
attacker, exploiting this flaw, would need to have network 
access to the network interface that tcpdump is running on.
Further, the attacker would have to be able to know or guess
that the local user is using tcpdump to decode RADIUS traffic.

Solution : http://rhn.redhat.com/errata/RHSA-2003-151.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the tcpdump package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"tcpdump-3.6.2-12.2.1AS.4", yank:"AS", release:"RHEL2.1") ) 
	security_hole(0);


