#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12393);
 script_version ("$Revision: 1.3 $");
script_cve_id("CAN-2003-0211");
			
 name["english"] = "RHSA-2003-161: xinetd";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of xinetd which is vulnerable
to a remote Denial of Service (DoS).  

Xinetd is a master server for handling multiple TCP/IP connections
to an application.  There is a flaw in this version of xinetd which
causes memory to be allocated but never freed when a connection was
refused.  An attacker, exploiting this flaw, would need to repeatedly
connect to an xinetd-monitored service port which refused the connection.
After many requests, the server will consume massive amounts of memory and
crash.

Solution : http://rhn.redhat.com/errata/RHSA-2003-161.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xinetd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"xinetd-2.3.11-2.AS2.1", yank:"AS", release:"RHEL2.1") ) 
	security_hole(0);


