#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12394);
 script_bugtraq_id(6185);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2002-1308");
			
 name["english"] = "RHSA-2003-163: Mozilla";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Mozilla which is
vulnerable to a remote heap overflow.

Mozilla is a web browser.  There is a heap overflow when
Mozilla handles a malformed Java .jar file.  An attacker,
exploiting this flaw, would need to be able to create a
malicious .jar file and then host it on a webserver.  The
attacker would then need to entice a local user to browse
to the malicious website and download the malicious .jar
file.

Solution : http://rhn.redhat.com/errata/RHSA-2003-163.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Mozilla package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"galeon-1.2.11-0.2.1", release:"RHEL2.1") ) 
{
	security_hole(0);
	exit(0);
}

if ( rpm_check( reference:"mozilla-1.0.2-4.2.1", release:"RHEL2.1") )
        security_hole(0);


