#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12395);
 script_bugtraq_id(7613);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2003-0188");
			
 name["english"] = "RHSA-2003-167: lv";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of lv which is vulnerable to a 
local command-execution bug. 

Lv is a file viewer.  It can decode and encode many different format
streams.  This version of lv is vulnerable to a flaw wherein a specially
crafted .lv file can be used to force subsequent users to execute 
commands.  When lv is run, it looks in the current directory for a .lv
configuration file.  If found, lv runs with the parameters specified
within the .lv file.  An attacker, exploiting this flaw, would need local
access and the ability to create .lv files in commonly used directories. 
A successful exploitation would result in arbitrary commands being run
by the exploited user.

Solution : http://rhn.redhat.com/errata/RHSA-2003-167.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the lv package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"lv-4.49.4-3.21AS.1", yank:"AS", release:"RHEL2.1") ) 
	security_hole(0);


