#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12396);
 script_bugtraq_id(7497);
 script_version ("$Revision: 1.4 $");
script_cve_id("CAN-2003-0255");
			
 name["english"] = "RHSA-2003-176: gnupg";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of gnupg prior to 1.0.7.

Gnupg is an open-source implementation of Pretty Good Privacy
(PGP) encryption tool.  This version of gnupg is vulnerable
to a bug wherein gnupg, when evaluating a pool of UIDs assigned
to a key, would take the highest trust value and assign it to
every UID.  

Solution : http://rhn.redhat.com/errata/RHSA-2003-176.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gnupg package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"gnupg-1.0.7-7.2.1", release:"RHEL2.1") ) 
	security_hole(0);


