#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12397);
 script_version ("$Revision: 1.3 $");
	
 name["english"] = "RHSA-2003-177: versions of the rhn_register and up2date";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running an older version of up2date.

Up2date is a package for retrieving updates from the Redhat Network. 
A machine, with older versions, will have problems downloading updates
or be unable to download updates.  By not having the ability to
auto-update the machine, the security posture of the machine may
be decreased.

Solution : http://rhn.redhat.com/errata/RHSA-2003-177.html
Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the versions of the rhn_register and up2date package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}


include("rpm.inc");

if ( rpm_check( reference:"rhn_register-2.8.34-1.2.1AS", yank:"AS", prefix:"rhn_register-", release:"RHEL2.1") ) 
	security_hole(0);


