#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12398);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-2002-0178");

 name["english"] = "RHSA-2003-180: sharutils";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the sharutils package installed.

There is a flaw in the uudecode program which include in this package which
may allow a local attacker to overwrite arbitrary files on the remote host
due to a race condition.

Solution : https://rhn.redhat.com/errata/RHSA-2003-180.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the sharutils package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check( reference:"sharutils-4.2.1-8.7.x", yank:".x",  release:"RHEL2.1") )
	security_warning(0);
