#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12399);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0354");

 name["english"] = "RHSA-2003-182: ghostscript";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the ghostscript package installed.

Ghostscript is an interpretor for the PostScript language.

There is a flaw in the way ghostscript validates postscript commands
which may allow an attacker to execute arbitrary commands on the remote
host by submitting a malicious print job.

Solution : https://rhn.redhat.com/errata/RHSA-2003-182.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ghostscript package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check( reference:"ghostscript-6.51-16.3", release:"RHEL2.1") )
	security_hole(0);
