#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12400);
 script_bugtraq_id(7520);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0370");

 name["english"] = "RHSA-2003-193: KDE";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the KDE packages installed.

Theer is a bug in the remote version of the Konqueror browser which
may make it vulnerable to man-in-the-middle attacks, due to the lack
of checks on SSL certificates.

Solution : https://rhn.redhat.com/errata/RHSA-2003-193.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the KDE package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check( reference:"kde-2.2.2-8",prefix:"(kde|kdelibs|arts)-", release:"RHEL2.1") )
	security_hole(0);
