#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12401);
 script_bugtraq_id(7791, 7797);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2003-0247", "CAN-2003-0248", "CAN-2003-0364");

 name["english"] = "RHSA-2003-195: Linux Kernel ";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Linux Kernel installed.

The remote version of the linux kernel contains the following security
issues :

- There is a bug in the tty layer which may allow any user to cause a kernel oops,
thus resulting in a denial of service

- There is a bug in the mxcsr code which may leave garbage in the CPU registers

- There is a bug in the TCP/IP stack in the way fragmented packets are re-assembled,
which may let a remote user cause a denial of service against the remote host

Solution : https://rhn.redhat.com/errata/RHSA-2003-195.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check( reference:"kernel-2.4.9-e.25", yank:"e.", release:"RHEL2.1") )
	security_hole(0);
