#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12402);
 script_bugtraq_id(7912);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0434");

 name["english"] = "RHSA-2003-197: Xpdf";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Xpdf package installed.

Xpdf is a PDF viewer of the X Window system. There is a buffer overflow
in the remote version of this software which may let an attacker execute
arbitrary code on the remote host.

To exploit this flaw, an attacker would need to craft a malformed PDF file
and send it to a victim on the remote host. He then would need for the victim
to attempt to view the file using Xpdf.

Solution : https://rhn.redhat.com/errata/RHSA-2003-197.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Xpdf package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check( reference:"xpdf-0.92-10", release:"RHEL2.1") )
	security_hole(0);
