#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12403);
 script_bugtraq_id(7550);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0282");

 name["english"] = "RHSA-2003-200: unzip";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the unzip package installed.

There is a bug in the remote version of this software which may let
an attacker overwrite arbitrary files on the remote system. To exploit
this flaw, an attacker would need to craft a zip archive with invalid
file names in it and send it to a victim on the remote host. When the
victim will attempt to unzip the archive, arbitrary files may be overwritten
with the archive content.

Solution : https://rhn.redhat.com/errata/RHSA-2003-200.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the unzip package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check( reference:"unzip-5.50-30", release:"RHEL2.1") )
	security_hole(0);
