#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12404);
 script_bugtraq_id(8031);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0251");

 name["english"] = "RHSA-2003-201: ypserv";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the ypserv package installed.

There is a bug in the remote version of this software which may let
an attacker disable this service remotely, by sending a malicious TCP
query and ignoring the server response, which will make it enter in
an infinite waiting state.

Solution : https://rhn.redhat.com/errata/RHSA-2003-201.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the ypserv package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check( reference:"ypserv-2.8-0.AS21E", yank:"AS", release:"RHEL2.1") )
	security_warning(0);
