#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12405);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0252");

 name["english"] = "RHSA-2003-207: nfs-utils";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the nfs-utils package installed.

nfs-utils provides a daemon for the kernel NFS server and related tools.

There is a buffer overflow in the remote version of this package which may
be used by an attacker to disable the NFS server remotely.

Solution : https://rhn.redhat.com/errata/RHSA-2003-207.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the nfs-utils package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check( reference:"nfs-utils-0.3.3-7.21AS", yank:"AS", release:"RHEL2.1") )
	security_warning(0);
else if ( rpm_exists(rpm:"nfs-utils-", release:"RHEL2.1") )
	set_kb_item(name:"CAN-2003-0252", value:TRUE);
