#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12407);
 script_bugtraq_id(7467);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0190");

 name["english"] = "RHSA-2003-224: openssh";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of OpenSSH installed.

When configured to allow password-based or challenge-response
authentication, sshd (the OpenSSH server) uses PAM (Pluggable
Authentication Modules) to verify the user's password. Under certain
conditions, OpenSSH versions prior to 3.6.1p1 reject an invalid
authentication attempt without first attempting authentication using PAM.

If PAM is configured with its default failure delay, the amount of time
sshd takes to reject an invalid authentication request varies widely enough
that the timing variations could be used to deduce whether or not an
account with a specified name existed on the server. This information
could then be used to narrow the focus of an attack against some other
system component.

Solution : https://rhn.redhat.com/errata/RHSA-2003-224.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the openssh package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check( reference:"openssh-3.1p1-8", yank:"p", prefix:"openssh-", release:"RHEL2.1") )
	security_warning(0);
else if ( rpm_exists(rpm:"openssh-", release:"RHEL2.1") )
	set_kb_item(name:"CAN-2003-0190", value:TRUE);
