#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12409);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0459");

 name["english"] = "RHSA-2003-236: KDE";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the KDE packages installed.

KDE is a desktop environment for the X Window system. There is a flaw in the
remote version of the web browser Konqueror which makes it discloses
URL-based credentials (ie: http://user:password@host/) in the referrer
field of its requests.

Solution : https://rhn.redhat.com/errata/RHSA-2003-236.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the KDE package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check( reference:"kde-2.2.2-9",prefix:"(kde|kdelib|arts)-", release:"RHEL2.1") )
	security_hole(0);
