#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12410);
 script_bugtraq_id(8002, 8042);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0462", "CAN-2003-0501", "CAN-2003-0550", "CAN-2003-0551", "CAN-2003-0552", "CAN-2003-0619", "CAN-2003-0699");

 name["english"] = "RHSA-2003-239: Linux Kernel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Linux Kernel installed.

The remote version of the Linux kernel is vulnerable to various security
issues :

- There is a file read race condition in the execve() system call which may
allow a local user to crash the system

- There is a bug in the /proc filesystem which may let a user read
arbitrary files by launching a suid program

- There are bugs in the STP protocol which may let a remote user gain
information about the bridge or which could lead to a remote denial of
service

- There is a bug in the forwarding table may be spoofed

- There is an integer signedness error in decode_fh() which may allow
an attacker to cause a denial of service on the remote host by sending
malformed XDR data to the remote NFS server

- The C-Media PCI sound driver might be used to gain superuser privileges

Solution : https://rhn.redhat.com/errata/RHSA-2003-239.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kernel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check( reference:"kernel-2.4.9-e.27",yank:"e", release:"RHEL2.1") )
	security_hole(0);
