#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12412);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0020", "CAN-2003-0192");

 name["english"] = "RHSA-2003-244: Apache and mod_ssl";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the apache and mod_ssl packages installed.

There are two bugs in the remote version of these packages which may cause
the cipher suite restrictions to be ignored in mod_ssl, and which may allow
an attacker to inject terminal emulators escape parameters in the remote log
files, which may then execute arbitrary code in the administrator of the web
server reads them using 'more'.

Solution : https://rhn.redhat.com/errata/RHSA-2003-244.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");


if ( rpm_check( reference:"apache-1.3.27-3",prefix:"apache-", release:"RHEL2.1"))
 	{
	security_warning(0);
	exit(0);
	}
else
	{
	 if ( rpm_exists(rpm:"apache-", release:"RHEL2.1") )
		{
		 set_kb_item(name:"CAN-2003-0020", value:TRUE);
		 set_kb_item(name:"CAN-2003-0192", value:TRUE);
		}
	}


if ( rpm_check(reference:"mod_ssl-2.8.12-3", release:"RHEL2.1")) 
	security_warning(0);
