#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12413);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0466");

 name["english"] = "RHSA-2003-246: wu-ftpd";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the wu-ftpd package installed.

wu-ftpd is a FTP server. There is an off-by-one overflow in the remote
version of this software which may allow an attacker to gain a shell
on the remote host with super-user privileges.

Solution : https://rhn.redhat.com/errata/RHSA-2003-246.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the wu-ftpd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"wu-ftpd-2.6.1-21", release:"RHEL2.1") ) 
	security_hole(0);
