#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12414);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0689");

 name["english"] = "RHSA-2003-249: glibc";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the glibc package installed.

The glibc is the standard C libraries used by every program on the remote
host. There is a bug in the function getgrouplist() in the remote version
of this package which may cause a segmentation fault if a user belongs to
too many groups. This bug may have security implications, depending on
the applications using it.

Solution : https://rhn.redhat.com/errata/RHSA-2003-249.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the glibc package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"glibc-2.2.4-32.8", prefix:"glibc-", release:"RHEL2.1") ) 
	security_warning(0);
