#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12415);
 script_bugtraq_id(4821, 5110, 6111);
 script_version ("$Revision: 1.4 $");
 script_cve_id("CAN-2002-1323", "CAN-2002-0615");

 name["english"] = "RHSA-2003-257: Perl";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Perl package installed.

Perl is a high-level scripting language. Two security issues have been
found in the remote version of this software :

- If safe.pm 2.0.7 and earlier is used, an attacker may break out of
safe compartments within Safe::reveal and Safe::rdo

- There is a cross-site scripting issue in CGI.pm which may affect
custom CGIs on the remote host.

Solution : https://rhn.redhat.com/errata/RHSA-2003-257.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the perl package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"perl-5.6.1-36.1.99ent", yank:"ent", prefix:"perl-([0-9]|suid)-", release:"RHEL2.1") ) 
	security_warning(0);
