#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12416);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0548", "CAN-2003-0549");

 name["english"] = "RHSA-2003-259: GDM";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the GDM package installed.

GDM is the Gnome Display Manager for X. It handles the login and authentication
of local or remote users (via XDMCP).

If XDMCP is enabled on the remote host, then an attacker may be able to exploit
a flaw in the remote version of this software to disable this service remotely
remotely, thus denying legitimate users from logging in.

Solution : https://rhn.redhat.com/errata/RHSA-2003-259.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gdm package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"gdm-2.2.3.1-20.1", release:"RHEL2.1") ) 
	security_warning(0);
