#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12417);
 script_bugtraq_id(8491);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0686");

 name["english"] = "RHSA-2003-262: pam_smb";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the pam_smb package installed.

The pam_smb module is a PAM extension which can be used to authenticate
users against a SMB server.

There is a buffer overflow in the remote version of this software which may 
let an attacker execute arbitrary code on the remote host, with superuser
privileges.

Solution : https://rhn.redhat.com/errata/RHSA-2003-262.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pam_smb package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"pam_smb-1.1.6-9.7", release:"RHEL2.1") ) 
	security_hole(0);
