#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12418);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0690", "CAN-2003-0692");

 name["english"] = "RHSA-2003-268: up2date";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the up2date package installed.

up2date and rhn_register are two utilities used to get security updates
and fixes from Red Hat. The remote host has an old version of these
utilities and won't be able to get updates from Red Hat.

Solution : https://rhn.redhat.com/errata/RHSA-2003-268.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the up2date package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"up2date-2.8.46.3-1.2.1AS", prefix:"up2date-", release:"RHEL2.1", yank:"AS") ) 
	security_hole(0);
