#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12419);
 script_bugtraq_id(8635, 8636);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0690", "CAN-2003-0692");

 name["english"] = "RHSA-2003-270: KDE";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the kdebase package installed.

KDE is a graphical desktop environment for the X Window System. There
is a bug in the KDE Display Manager (KDM) installed on the remote host
due to the way it checks the result of the pam_setcred() function. If an
error occurs during the PAM lookup, then KDM will grant access to the username,
whatever password has been set up. An attacker could exploit this flaw
to gain a root shell locally or remotely on the remote host.

Solution : https://rhn.redhat.com/errata/RHSA-2003-270.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the kdebase package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"kdebase-2.2.2-11", prefix:"kdebase-", release:"RHEL2.1") ) 
	security_hole(0);
