#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12420);
 script_bugtraq_id(8588, 8589);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0720", "CAN-2003-0721");

 name["english"] = "RHSA-2003-274: Pine";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Pine package installed.

Pine is a console-mode mail user agent. There is a flaw in the remote version
of this software which may allow an attacker to execute arbitrary code
on this host.

To exploit this flaw an attacker would need to send a malformed message
to a victim using pine on the remote host. By sending a message containing
a malformed MIME type, an attacker may be able to execute arbitrary commands
on the remote host, when his email is being read by pine.

Solution : https://rhn.redhat.com/errata/RHSA-2003-274.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pine package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"pine-4.44-19.21AS.0", release:"RHEL2.1", yank:"AS") ) 
	security_hole(0);
