#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12421);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0682", "CAN-2003-0693", "CAN-2003-0695");

 name["english"] = "RHSA-2003-280: OpenSSH";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the OpenSSH package installed.

There are various flaws in the remote version of OpenSSH which may lead
to remote code execution. An attacker could exploit this flaw to gain
a shell on the remote host with super-user privileges.

Solution : https://rhn.redhat.com/errata/RHSA-2003-280.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the OpenSSH package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"openssh-3.1p1-14", prefix:"openssh-", release:"RHEL2.1") ) 
	security_hole(0);
else
 {
   if ( rpm_exists( rpm:"openssh-", release:"RHEL2.1") )
	 set_kb_item(name:"CAN-2003-0682", value:TRUE);
 }

