#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12422);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0694");

 name["english"] = "RHSA-2003-284: Sendmail";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the Sendmail package installed.

Sendmail is a mail transport agent (MTA). There is a flaw in the remote
version of this software which may allow an attacker to execute arbitrary
code on the remote host by sending a specially malformed email which will
trigger a heap overflow in the prescan() function.

An attacker could exploit this flaw to gain a shell on the remote host.

Solution : https://rhn.redhat.com/errata/RHSA-2003-284.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Sendmail package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"sendmail-8.11.6-28.72", prefix:"sendmail-", release:"RHEL2.1") ) 
	security_hole(0);

