#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12423);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0773", "CAN-2003-0774", "CAN-2003-0775", "CAN-2003-0776", "CAN-2003-0777", "CAN-2003-0778");

 name["english"] = "RHSA-2003-285: SANE";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the SANE package installed.

SANE is a set of drivers to use document scanners. There is a daemon program
in the remote version of SANE (saned) whose purpose is to let a remote host
use a scanner, which contains several vulnerabilities which may let a user
bypass IP restrictions set in saned.conf or disable the remote service remotely.

Solution : https://rhn.redhat.com/errata/RHSA-2003-285.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the SANE package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"sane-backends-1.0.5-4.3", prefix:"sane-backends-", release:"RHEL2.1") ) 
	security_warning(0);

