#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12424);
 script_bugtraq_id(8514);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0690", "CAN-2003-0730");
 name["english"] = "RHSA-2003-289: XFree86";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the XFree86 package installed.

The remote version of this software contains various flaws which may allow
a local or remote attacker to execute arbitrary code with root privileges
on this host. It also contains a bug in the way pam_setcred() is called, which
may allow attackers to gain root privileges using this problem.

Solution : https://rhn.redhat.com/errata/RHSA-2003-289.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the XFree86 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"XFree86-4.1.0-50.EL", prefix:"XFree86-", release:"RHEL2.1", yank:"EL") ) 
	security_hole(0);

