#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12425);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0543", "CAN-2003-0544");
 name["english"] = "RHSA-2003-293: OpenSSL";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the OpenSSL package installed.

There is a bug in the remote version of this software which may let an attacker
crash SSL-enabled services on the remote host.

Solution : https://rhn.redhat.com/errata/RHSA-2003-293.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the OpenSSL package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"openssl-0.9.6b-35.7", prefix:"openssl-", release:"RHEL2.1") ||  
     rpm_check( reference:"openssl095a-0.9.5a-23.7.3", release:"RHEL2.1" ) ||
     rpm_check( reference:"openssl096-0.9.6-23.7", release:"RHEL2.1") ) 
	security_warning(0);

