#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12426);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0740");
 name["english"] = "RHSA-2003-297: stunnel";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the stunnel package installed.

stunnel is a wrapper for network connections. There are a couple of bugs
in the remote version of this software which may lead to remote code
execution.

Solution : https://rhn.redhat.com/errata/RHSA-2003-297.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the stunnel package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"stunnel-3.26-1.7.3", release:"RHEL2.1") )
	security_hole(0);

