#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12427);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0858", "CAN-2003-0795");
 name["english"] = "RHSA-2003-305: fileutils";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the zebra package installed.

zebra is a routing software. There is a bug in the remote version of this 
program which may allow an attacker to disable it remotely by sending a 
malformed packet to the telnet port of this service. 

An attacker could exploit this flaw to bring down some parts of the network.

Solution : https://rhn.redhat.com/errata/RHSA-2003-305.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the zebra package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"zebra-0.91a-10.21AS", yank:"AS", release:"RHEL2.1") )
	security_hole(0);

