#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12428);
 script_bugtraq_id(8875);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0853", "CAN-2003-0854");
 name["english"] = "RHSA-2003-310: fileutils";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the fileutils package installed.

The fileutils package contains various command-line utilities, one of which
being the 'ls' command. 

There is a flaw in the remote version of this software which may lead to
memory starvation. To exploit this flaw, an attacker would need to pass a
specially malformed string to the ls command. Since ls is sometimes used by
FTP servers, this vulnerability may be exploitable remotely.

Solution : https://rhn.redhat.com/errata/RHSA-2003-310.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the fileutils package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"fileutils-4.1-10.4", release:"RHEL2.1") )
	security_warning(0);

