#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12429);
 script_bugtraq_id(9093);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0855");
 name["english"] = "RHSA-2003-312: Pan";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the pan package installed.

pan is a Gnome NNTP (news) reader. There is a flaw in the remote version
of this software which may cause it to crash when parsing a message header
containing a very long address. It is believed that code can not be executed
thru this flaw.

Solution : https://rhn.redhat.com/errata/RHSA-2003-312.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the pan package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( reference:"pan-0.9.7-3", release:"RHEL2.1") )
	security_warning(0);

