#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12430);
 script_bugtraq_id(8741);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2003-0901");
 name["english"] = "RHSA-2003-314: PostgreSQL";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the postgresql package installed.

PostgreSQL is a database. There is a buffer overflow in the to_ascii() function
of the remote database which may let a user with a database account to escalate
his privileges to the 'postgres' level.
A remote attacker could exploit this flaw to get an interactive shell on this 
host.

Solution : https://rhn.redhat.com/errata/RHSA-2003-314.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the postgresql package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check( prefix:"postgresql-", reference:"postgresql-7.1.3-5.rhel2.1AS", yank:"rhel", release:"RHEL2.1") )
	security_hole(0);

