#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12431);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0858");
 name["english"] = "RHSA-2003-315: quagga";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the quagga package installed.

quagga, an open-source implementation of a TCP/IP routing software,
is vulnerable to a flaw which may allow a local user to perform a local 
denial of service on the remote host by locally sending spoofed messages 
to the kernel netlink interface.

Solution : https://rhn.redhat.com/errata/RHSA-2003-315.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the quagga package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(prefix:"quagga-", reference:"quagga-0.96.2-8.3E", yank:"E", release:"RHEL3") )
 security_hole(port);
