#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12432);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-0586");
 name["english"] = "RHSA-2003-317: iproute";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the iproutepackage installed.

iproute, a package containing IP routing and network device
configuration tools, is vulnerable to a flaw which may allow
a local user to perform a local denial of service on the remote
host by locally sending spoofed messages to the kernel netlink
interface.

Solution : https://rhn.redhat.com/errata/RHSA-2003-317.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the iproute package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Red Hat Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/RedHat/rpm-list");
 exit(0);
}



include("rpm.inc");

if ( rpm_check(reference:"iproute-2.4.7-11.30E.1", yank:"E", release:"RHEL3") ||
     rpm_check(reference:"iproute-2.4.7-7.AS21.1", yank:"AS", release:"RHEL2.1") )
		security_hole(0);
